import { UseCarRes, UseCarServerRes } from 'entities/Car/api/useCar/useCar';

export function carParser(res: UseCarServerRes): UseCarRes {
    const { cars, models } = res;
    const firstCar = cars[0]; // @TODO DRIVEMATICSDEV-491

    if (!firstCar) {
        throw new Error('Car not found');
    }

    const { model_id, number, taxi_company } = firstCar;

    return {
        ...firstCar,
        model: models[model_id].name || firstCar.model_id,
        number: number.toUpperCase(),
        taxi_park: taxi_company.name,
    };
}
