import { EMPTY_DATA } from 'constants/constants';

export function formatCarNumber(value?: string): string {
    if (!value) {
        return EMPTY_DATA;
    }

    const number = value.replace(/\s/gi, '').toUpperCase();

    const array = number.match(/[a-zа-я]+|[^a-z^а-я]+/gi);

    if (array?.length) {
        return array.join('\u00a0');
    }

    return number;
}
