import { CarOfferConfigSchema } from 'entities/Car/types/CarOfferConfigSchema';
import { CarOfferSchema } from 'entities/Car/types/CarOfferSchema';

export function getCarOfferOptions(
    keys: Optional<CarOfferSchema['offer_options']>,
    options: CarOfferConfigSchema['offer_options'],
): string[] {
    if (!keys || !Object.keys(keys).length) {
        return [];
    }

    const arrayOfKeys = Object.keys(keys);

    let items: string[] = [];

    for (let i = 0; i < arrayOfKeys.length; i++) {
        const key = keys[arrayOfKeys[i]];
        if (key) {
            const item = options?.find(({ id }) => id === arrayOfKeys[i]);

            items.push(item ? item.title : '???');
        }
    }

    return items;
}
