import { CarOfferSessionStatus } from 'entities/Car/consts/CarOfferSessionStatus';

interface GetCarOfferSessionStatusProps {
    since?: Date;
    until?: Date;
    actual_since?: Date;
    actual_until?: Date;
}

export function getCarOfferSessionStatus({
    since,
    until,
    actual_since,
    actual_until,
}: GetCarOfferSessionStatusProps): Optional<CarOfferSessionStatus> {
    const now = new Date();

    if (actual_until && now > actual_until) {
        return CarOfferSessionStatus.COMPLETED;
    }

    if (actual_since && now > actual_since) {
        return CarOfferSessionStatus.IN_PROGRESS;
    }

    if (since && now > since && until && now > until) {
        return CarOfferSessionStatus.OUTDATED;
    }

    return;
}
