import { CarServiceJobType } from 'entities/Car/consts/CarServiceJobType';

import { i18n } from 'entities/Car/helpers/getCarServiceJobTypeName/getCarServiceJobTypeName.i18n';

export const CAR_SERVICE_MENU_ITEMS = [
    { label: i18n('Scheduled maintenance'), value: CarServiceJobType.SCHEDULED_MAINTENANCE },
    { label: i18n('Tires'), value: CarServiceJobType.TIRES },
    { label: i18n('Repair'), value: CarServiceJobType.REPAIR },
];

export function getCarServiceJobTypeName(key: CarServiceJobType): string {
    const jobTypeMap = CAR_SERVICE_MENU_ITEMS.reduce((memo: Dict, item) => {
        memo[item.value] = item.label!;

        return memo;
    }, {});

    return jobTypeMap[key];
}
