import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Alarm: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Alarm',
        ru: 'Тревога',
        cs: 'Alarm',
    },
    'Camera faced away': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Camera faced away',
        ru: 'Камера отвернута',
        cs: 'Kamera nasměrována mimo',
    },
    'Camera lens blocked': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Camera lens blocked',
        ru: 'Камера закрыта',
        cs: 'Objektiv kamery blokován',
    },
    'Camera turned away': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Camera turned away',
        ru: 'Отворачивание камеры',
        cs: 'Kamera natočena mimo',
    },
    'Car is blocked': {
        _meta: {
            context: 'Signal name',
            group: '1',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car is blocked',
        ru: 'Блокировка машины',
        cs: 'Vůz je zablokován',
    },
    'Careless driving': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: 'Careless driving',
        ru: 'Неаккуратное вождение',
        cs: 'Neopatrná jízda',
    },
    'Distracted by phone': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Distracted by phone',
        ru: 'Отвлечение на телефон',
        cs: 'Odvedení pozornosti telefonem',
    },
    Distraction: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Distraction',
        ru: 'Невнимательность',
        cs: 'Odvedení pozornosti',
    },
    'Eyes closed': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Eyes closed',
        ru: 'Закрытые глаза',
        cs: 'Zavřené oči',
    },
    'Inactivity: 1 hour': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Inactivity: 1 hour',
        ru: 'Простой: 1 час',
        cs: 'Neaktivní: 1 hodina',
    },
    'Leaving geofence': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Leaving geofence',
        ru: 'Выезд из зоны',
        cs: 'Opuštění zóny',
    },
    Overmileage: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Overmileage',
        ru: 'Перепробег',
        cs: 'Počet ujetých kilometrů nad limit',
    },
    'Road accident': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Road accident',
        ru: 'ДТП',
        cs: 'Dopravní nehoda',
    },
    'Seat belt not fastened': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Seat belt not fastened',
        ru: 'Непристегнутый ремень',
        cs: 'Bezpečnostní pás není zapnutý',
    },
    Smoking: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Smoking',
        ru: 'Курение',
        cs: 'Kouření',
    },
    'Telematics lag': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Telematics lag',
        ru: 'Лаг телематики',
        cs: 'Zpoždění telematiky',
    },
    'Very drowsy': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Very drowsy',
        ru: 'Сильная сонливость',
        cs: 'Velmi ospalý',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
