import { SignalDescriptionSchema } from 'entities/Signal/types/SignalDescriptionSchema';

import { i18n } from 'entities/Car/helpers/getCarSignalDescriptionDisplayName/getCarSignalDescriptionDisplayName.i18n';

// check SignalType
const signals: Record<string, string> = {
    signalq_alarm_tag: i18n('Alarm'),
    signalq_smoking_tag: i18n('Smoking'),
    signalq_camera_overturn_tag: i18n('Camera turned away'),
    signalq_bad_camera_pose_tag: i18n('Camera faced away'),
    signalq_trash_frames_tag: i18n('Camera lens blocked'),
    signalq_phone_tag: i18n('Distracted by phone'),
    signalq_distraction_tag: i18n('Distraction'),
    signalq_tired_tag: i18n('Very drowsy'),
    signalq_eyeclose_tag: i18n('Eyes closed'),
    signalq_seatbelt_tag: i18n('Seat belt not fastened'),
    signalq_road_accident_tag: i18n('Road accident'),

    leasing_car_is_blocked: i18n('Car is blocked'),
    scoring_trace_tag: i18n('Careless driving'),
    car_in_deny_zone: i18n('Leaving geofence'),
    car_1h_dont_move: i18n('Inactivity: 1 hour'),
    telematics_tag_alerting: i18n('Telematics lag'),
    car_over_mileage_signal: i18n('Overmileage'),
    overmileage: i18n('Overmileage'),
};

export function getCarSignalDescriptionDisplayName(description: SignalDescriptionSchema): string {
    return signals[description.name] || description.display_name;
}
