import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Dangerous ride': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dangerous ride',
        ru: 'Опасная поездка',
        cs: 'Nebezpečná jízda',
    },
    'Very dangerous ride': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Very dangerous ride',
        ru: 'Очень опасная поездка',
        cs: 'Velmi nebezpečná jízda',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
