import { VERY_DANGEROUS_SESSION_BORDER } from 'constants/constants';

import { getCarSignalDescriptionDisplayName } from 'entities/Car/helpers/getCarSignalDescriptionDisplayName/getCarSignalDescriptionDisplayName';
import { SignalDescriptionSchema } from 'entities/Signal/types/SignalDescriptionSchema';
import { SignalSchema } from 'entities/Signal/types/SignalSchema';

import { SCORING_TRACE_TAG } from 'components/Cars/constants';

import { i18n } from 'entities/Car/helpers/getCarSignalDisplayName/getCarSignalDisplayName.i18n';

export function getCarSignalDisplayName(signal: SignalSchema, description: SignalDescriptionSchema): string {
    const { name, details } = signal;

    if (!description) {
        // preapproval signals have fake name
        return getCarSignalDescriptionDisplayName({
            name: `signalq_${name}_tag`,
            display_name: name,
        } as SignalDescriptionSchema);
    }

    if (name === SCORING_TRACE_TAG && description) {
        const sessionScore = details.score ?? 0;

        // @TODO перевод на сторону сервера?
        return sessionScore < VERY_DANGEROUS_SESSION_BORDER ? i18n('Dangerous ride') : i18n('Very dangerous ride');
    }

    // @TODO server side translate
    return getCarSignalDescriptionDisplayName(description);
}
