import { VERY_DANGEROUS_SESSION_BORDER } from 'constants/constants';

import { isSignalsRedesignFlag } from 'utils/isSignalsRedesignFlag';

import { SignalPriority } from 'entities/Signal/consts/SignalPriority';
import { SignalDescriptionSchema } from 'entities/Signal/types/SignalDescriptionSchema';
import { SignalSchema } from 'entities/Signal/types/SignalSchema';

import { SCORING_TRACE_TAG } from 'components/Cars/constants';

export function getCarSignalPriority(signal: SignalSchema, description: SignalDescriptionSchema): SignalPriority {
    const { name, details } = signal;

    if (!description) {
        // preapproval signals
        return SignalPriority.NORMAL;
    }

    if (!isSignalsRedesignFlag() && name === SCORING_TRACE_TAG && description) {
        const sessionScore = details.score ?? 0;

        return sessionScore < VERY_DANGEROUS_SESSION_BORDER ? SignalPriority.WARNING : SignalPriority.CRITICAL;
    }

    return description.priority;
}
