import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Camera closed': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Camera closed',
        ru: 'Закрыта',
        cs: 'Kamera uzavřena',
    },
    Closed: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Closed',
        ru: 'Закрыта',
        cs: 'Zavřeno',
    },
    'Faced away': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Faced away',
        ru: 'Отвёрнута',
        cs: 'Pohled stranou',
    },
    Off: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Off',
        ru: 'Выкл',
        cs: 'Vypnuto',
    },
    Offline: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Offline',
        ru: 'Оффлайн',
        cs: 'Offline',
    },
    On: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'On',
        ru: 'Вкл',
        cs: 'Zapnuto',
    },
    'Turned off': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Turned off',
        ru: 'Не работает',
        cs: 'Vypnuto',
    },
    'Turned on': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Turned on',
        ru: 'Работает',
        cs: 'Zapnuto',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
