import { CarSignalqStatusType } from 'entities/Car/consts/CarSignalqStatusType';

import { i18n } from 'entities/Car/helpers/getCarSignalqStatus/getCarSignalqStatus.i18n';

const TRANSLATES: Record<CarSignalqStatusType, string> = {
    [CarSignalqStatusType.TURNED_ON]: i18n('Turned on'),
    [CarSignalqStatusType.TURNED_OFF]: i18n('Turned off'),
    [CarSignalqStatusType.OFFLINE]: i18n('Offline'),
    [CarSignalqStatusType.FACED_AWAY]: i18n('Faced away'),
    [CarSignalqStatusType.CAMERA_CLOSED]: i18n('Camera closed'),
};

const SHORT_TRANSLATES: Partial<Record<CarSignalqStatusType, string>> = {
    [CarSignalqStatusType.TURNED_ON]: i18n('On'),
    [CarSignalqStatusType.TURNED_OFF]: i18n('Off'),
    [CarSignalqStatusType.CAMERA_CLOSED]: i18n('Closed'),
};

export function getCarSignalqStatus(status: Optional<CarSignalqStatusType>, short?: boolean): Optional<string> {
    if (!status) {
        return undefined;
    }

    if (short && SHORT_TRANSLATES.hasOwnProperty(status)) {
        return SHORT_TRANSLATES[status];
    }

    return TRANSLATES.hasOwnProperty(status) ? TRANSLATES[status] : status;
}
