import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{speed} km/h': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: '{speed} km/h',
        ru: '{speed} км/ч',
        cs: '{speed} km/h',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
