import { EMPTY_DATA } from 'constants/constants';

import { CarStatusType } from 'entities/Car/consts/CarStatusType';
import { CarCommonSpeedTraitSchema } from 'entities/Car/types/CarCommonSpeedTraitSchema';
import { CarSchema } from 'entities/Car/types/CarSchema';

import { i18n } from 'entities/Car/helpers/getCarSpeed/getCarSpeed.i18n';

export function getCarSpeed(car: Pick<CarSchema, 'status'> & CarCommonSpeedTraitSchema): Optional<string> {
    const speed = car?.status === CarStatusType.RIDING && car?.speed ? Math.round(car.speed) : null;

    return speed ? i18n('{speed} km/h', { speed }) : EMPTY_DATA;
}
