import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Blocked: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Blocked',
        ru: 'Заблокирована',
        cs: 'Blokováno',
    },
    'Delayed block': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Delayed block',
        ru: 'Отложенная блокировка',
        cs: 'Odložené blokování',
    },
    'Delayed unblock': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Delayed unblock',
        ru: 'Отложенная разблокировка',
        cs: 'Odložené odblokování',
    },
    Dismantling: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dismantling',
        ru: 'Демонтаж оборудования',
        cs: 'Demontáž',
    },
    'Engine off': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Engine off',
        ru: 'Двигатель выключен',
        cs: 'Motor vypnutý',
    },
    'Engine on': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Engine on',
        ru: 'Двигатель включён',
        cs: 'Motor zapnutý',
    },
    Installation: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Installation',
        ru: 'Установка оборудования',
        cs: 'Instalace',
    },
    'No signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'No signal',
        ru: 'Нет сигнала',
        cs: 'Žádný signál',
    },
    Riding: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Riding',
        ru: 'В движении',
        cs: 'Jízda',
    },
    Unknown: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Unknown',
        ru: 'Неизвестно',
        cs: 'Neznámý',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
