import { CarStatusType } from 'entities/Car/consts/CarStatusType';

import { i18n } from 'entities/Car/helpers/getCarStatus/getCarStatus.i18n';

const TRANSLATES: Record<CarStatusType, string> = {
    [CarStatusType.UNKNOWN]: i18n('Unknown'),
    [CarStatusType.INSTALLATION]: i18n('Installation'),
    [CarStatusType.UNINSTALL_TELEMATICS]: i18n('Dismantling'),
    [CarStatusType.NO_SIGNAL]: i18n('No signal'),
    [CarStatusType.BLOCKED]: i18n('Blocked'),
    [CarStatusType.DELAYED_BLOCK]: i18n('Delayed block'),
    [CarStatusType.DELAYED_UNBLOCK]: i18n('Delayed unblock'),
    [CarStatusType.RIDING]: i18n('Riding'),
    [CarStatusType.ENGINE_ON]: i18n('Engine on'),
    [CarStatusType.ENGINE_OFF]: i18n('Engine off'),
};

export function getCarStatus(status: Optional<CarStatusType>): Optional<string> {
    return status && TRANSLATES.hasOwnProperty(status) ? TRANSLATES[status] : status;
}
