import { EMPTY_DATA } from 'constants/constants';

import { CarTelematicsRes } from 'entities/Car/api/useCarTelematics/useCarTelematics';

import { i18n } from 'entities/Car/helpers/getCarTelematicSpeed/getCarTelematicSpeed.i18n';

export function getCarTelematicSpeed(carTelematics: CarTelematicsRes): Optional<string> {
    const unprocessedSpeed = carTelematics?.speed?.value;
    const speed = typeof unprocessedSpeed === 'number' ? Math.round(unprocessedSpeed) : null;

    return speed ? i18n('{speed} km/h', { speed }) : EMPTY_DATA;
}
