import { ICustomFilterItem } from 'utils/getFlags';
import { getI18nLocale } from 'utils/language/getI18nLocale';

import { I18nLocale } from 'shared/consts/I18nLocale';

export type GetCarsFilterOptions = {
    label: string;
    id: string;
};

// @todo: add test
export function getCarsFilterOptions(filters: Optional<ICustomFilterItem[]>): GetCarsFilterOptions[] {
    if (!filters) {
        return [];
    }

    const locale = getI18nLocale();

    return filters?.map((filter) => {
        const tag = filter?.tag;

        return {
            label: filter?.[locale] || filter?.[I18nLocale['en-US']] || tag,
            id: tag,
        };
    });
}
