import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'New booking': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'New booking',
        ru: 'Новое бронирование',
        cs: 'Nová rezervace',
    },
    'New service': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'New service',
        ru: 'Новое техническое обслуживание',
        cs: 'Nový servis',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
