import * as React from 'react';

import { CarsScheduleGridCreateCallback } from 'features/CarsScheduleGrid/types/CarsScheduleGridCreateCallback';

import { CarsScheduleFormType } from 'entities/Car/consts/CarsScheduleFormType';

import { MenuItemOptions } from 'shared/ui/MenuItem/MenuItem';

import { i18n } from 'entities/Car/helpers/getCarsScheduleGridMenuItems/getCarsScheduleGridMenuItems.i18n';

export function getCarsScheduleGridMenuItems(
    onCreate?: CarsScheduleGridCreateCallback,
    options?: { id: string; since: Date; until: Date },
): MenuItemOptions<CarsScheduleFormType>[] {
    function onMenuItemClickHandler({ currentTarget }: React.MouseEvent<HTMLSpanElement>) {
        const type = currentTarget.parentElement?.getAttribute('data-value') as CarsScheduleFormType;

        if (onCreate) {
            onCreate(type, options);
        }
    }

    return [
        {
            label: i18n('New booking'),
            value: CarsScheduleFormType.BOOKING,
            onClick: onMenuItemClickHandler,
        },

        {
            label: i18n('New service'),
            value: CarsScheduleFormType.SERVICE,
            onClick: onMenuItemClickHandler,
        },
    ];
}
