import { CarOfferStatusSchema } from 'entities/Car/types/CarOfferStatusSchema';
import { CarSearchSchema } from 'entities/Car/types/CarSearchSchema';
import { GeoInputData } from 'entities/Geo';
import { UserInputData } from 'entities/User';

import { FormDateTimeRangeSchema } from 'shared/types/FormDateTimeRangeSchema';

export interface CarOfferFormSchema extends FormDateTimeRangeSchema {
    user: UserInputData;
    car: CarSearchSchema;

    offer_options?: Record<string, boolean>;

    delivery_location: GeoInputData;
    return_location: GeoInputData;

    insurance_type: string;
    comment?: string;
    currency: string;
    total_payment: string | number;
    deposit: string | number;
    limit_km_per_day: string | number;
    overrun_cost_per_km: string | number;
    status: CarOfferStatusSchema;

    // meta type for messages based on server errors
    _serverError?: never;
}
