export type CarOfferPricingRatesSchema = Array<{
    id: string;
    end: number;
    tariff_costs: Array<{
        id: string;
        name: string;
        daily_cost: Optional<number>;
    }>;
}>;

export interface CarOfferPricingSchema {
    grid: Nullable<CarOfferPricingRatesSchema>;
    insurances: Array<{ id: string }>;
    insurances_grid: Nullable<
        Array<{
            id: string;
            insurances_costs: Array<{
                id: string;
                name: string;
                cost: number;
            }>;
        }>
    >;
    insurances_list: Array<{ id: string; title: string }>;
    limits_grid: Nullable<
        Array<{
            id: string;
            limits: Array<{
                id: string;
                name: string;
                mileage: number;
            }>;
        }>
    >;
    options: Array<{
        id: string;
        cost: number;
        is_cost_per_day: boolean;
        max_total_cost: Nullable<number>;
    }>;
    options_list: Array<{ id: string; title: string }>;
    ranges: Array<{ id: string; end: number }>;
    tariffs: Array<{
        id: string;
        name: string;
        cars_count: number;
        deposit: number;
        overrun_cost_per_km: number;
        category: {
            id: string;
            name: string;
        };
    }>;
}
