import { CarOfferStatusSchema } from 'entities/Car/types/CarOfferStatusSchema';

type CarOfferPrimaryOptions =
    | { id: 'insurance_types'; types: Array<{ id: string; title: string }> }
    | { id: 'currencies'; currencies: Array<{ id: string; name: string }> }
    | { id: 'statuses'; statuses: Array<{ id: string; title: string }> }
    | { id: 'limit_km_per_day' | 'overrun_cost_per_km'; default_value: number }
    | {
          id: 'delivery_locations' | 'return_locations';
          locations: Array<{ lon: number; lat: number; location_name: string; id: string }>;
      };

export interface CarOfferSchema {
    offer_id: string;
    car_id: string;

    primary: CarOfferPrimaryOptions[];
    secondary: Array<{ id: string; title: string }>;

    offer_options: Record<string, boolean>;
    return_location: [number, number];
    delivery_location: [number, number];
    return_location_name: string;
    delivery_location_name: string;
    since: number;
    until: number;
    insurance_type: string;
    comment?: string;
    currency: string;
    total_payment: number;
    deposit: number;
    limit_km_per_day: number;
    overrun_cost_per_km: number;
    status: CarOfferStatusSchema;

    mileage_limit?: number;
}
