import { CarStatusType } from 'entities/Car/consts/CarStatusType';
import { CarLeasingStatsSchema } from 'entities/Car/types/CarLeasingStatsSchema';
import { CarTelematicsSchema } from 'entities/Car/types/CarTelematicsSchema';

export interface CarSchema {
    id: string;
    number: string;
    vin: string;
    model_id: string;
    model: string;
    status: CarStatusType;
    view: number;
    location: {
        lat: number;
        lon: number;
        course: number;
        tags: any[];
        timestamp: number;
    };
    telematics?: CarTelematicsSchema;
    tags?: any[];
    leasing_stats: CarLeasingStatsSchema;
    taxi_park: string;
    taxi_company: {
        name: string;
        id: string;
    };
    aggressive_rank: number;
    aggressive_score: number;
    aggressive_score_tag_id: string;
}
