import * as React from 'react';
import cn from 'classnames/bind';

import { EMPTY_DATA } from 'constants/constants';

import { getCarNumber } from 'entities/Car/helpers/getCarNumber/getCarNumber';

import { Shimmer } from 'shared/ui/Shimmer/Shimmer';

import styles from 'entities/Car/ui/CarCardHeaderTitle/CarCardHeaderTitle.css';

export interface CarCardHeaderTitleProps {
    className?: string;
    // @todo: carInfo: Pick<ICarInfo, 'model' | 'number' | 'vin'>;
    model?: string;
    number?: string;
    vin?: string;
    isLoading?: boolean;
}

const cx = cn.bind(styles);

export const CarCardHeaderTitle: React.FC<CarCardHeaderTitleProps> = React.memo(function CarCardHeaderTitle({
    className,
    model,
    number,
    vin,
    isLoading,
}) {
    return (
        <div className={cx(styles.carCardHeaderTitle, { loading: isLoading }, [className])}>
            {isLoading ? (
                <>
                    <Shimmer className={styles.modelShimmer} />

                    <Shimmer className={styles.numberShimmer} />
                </>
            ) : (
                <>
                    <h2 className={styles.model}>{model || EMPTY_DATA}</h2>

                    <p className={styles.number}>{getCarNumber(number, vin)}</p>
                </>
            )}
        </div>
    );
});
