import * as React from 'react';

import { UseCarResource } from 'entities/Car/api/useCar/useCar';
import { CarCardHeaderTitle } from 'entities/Car/ui/CarCardHeaderTitle/CarCardHeaderTitle';

import { useResourceReader } from 'shared/hooks/useResourceReader/useResourceReader';

export interface CarHeaderTitleProps {
    resource?: UseCarResource;
}

export const CarHeaderTitle: React.FC<CarHeaderTitleProps> = function CarHeaderTitle({ resource }) {
    const car = useResourceReader(resource);

    if (!car) {
        return <CarCardHeaderTitle isLoading />;
    }

    return (
        <CarCardHeaderTitle
            model={car.model}
            number={car.number}
            vin={car.vin}
        />
    );
};
