import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { CarModelInput, CarModelInputProps } from 'entities/Car/ui/CarModelInput/CarModelInput';

import { InputSize } from 'shared/consts/InputSize';

const storybookMeta = createStorybookMeta<CarModelInputProps>({
    title: 'entities/Car/CarModelInput',
    component: CarModelInput,

    args: {
        storybookWidth: '320px',

        inputSize: InputSize.M,
        maxHeight: 270,
        placeholder: 'Select Car Model',
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarModelInputProps>(CarModelInput);

export const normal = Template.bind({});
normal.args = {};

normal.hermioneFn = async (browser, selector) => {
    const menuEl = '[role="menu"]';

    await browser.$(selector).click();
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('suggest0', [selector, menuEl]);

    await browser.$('[type="text"]').setValue('m');
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('suggest1', [selector, menuEl]);

    await browser.$('[type="text"]').setValue('me');
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('suggest2', [selector, menuEl]);

    await browser.$('li[role="option"]:nth-child(2)').click();
    await browser.assertView('selected', selector);

    await browser.$('span[role="button"]').click();
    await browser.assertView('clear', selector);
};
