import * as React from 'react';

import { fetchCarModels } from 'entities/Car/api/fetchCarModels/fetchCarModels';
import { CarModelSchema } from 'entities/Car/types/CarModelSchema';

import { Suggest, SuggestProps, SuggestValueState } from 'shared/ui/Suggest/Suggest';

import styles from 'entities/Car/ui/CarInput/CarInput.css';

export interface CarModelInputProps
    extends Omit<
        SuggestProps<CarModelSchema>,
        'initialValue' | 'onSuggestChange' | 'dataProvider' | 'menuItemsProvider'
    > {
    initialValue?: CarModelSchema;

    onCarModelInputChange?(model: Optional<CarModelSchema>): void;
}

function modelInputText(item: CarModelSchema): string {
    const { name, fuel_type } = item;

    return name + ' ' + fuel_type;
}

// @todo: add storybook test
export const CarModelInput: React.FC<CarModelInputProps> = function CarModelInput({
    initialValue,
    onCarModelInputChange,
    ...otherProps
}) {
    const menuItemsProvider = React.useCallback((items: CarModelSchema[]) => {
        return items.map((item) => {
            const { code, name, fuel_type } = item;

            return {
                id: code,
                text: modelInputText(item),
                data: item,
                content: (
                    <span className={styles.menu}>
                        <span className={styles.model}>{name}</span>

                        {fuel_type}
                    </span>
                ),
            };
        });
    }, []);

    const onChange = React.useCallback(
        (textValue: string, dataValue: Optional<CarModelSchema>) => {
            if (onCarModelInputChange) {
                onCarModelInputChange(dataValue);
            }
        },
        [onCarModelInputChange],
    );

    const suggestInitValue = React.useMemo<Optional<SuggestValueState<CarModelSchema>>>(() => {
        if (!initialValue) {
            return undefined;
        }

        return {
            id: initialValue.code,
            text: modelInputText(initialValue),
            data: initialValue,
        };
    }, [initialValue]);

    return (
        <Suggest<CarModelSchema>
            {...otherProps}
            initialValue={suggestInitValue}
            onSuggestChange={onChange}
            dataProvider={fetchCarModels}
            menuItemsProvider={menuItemsProvider}
        />
    );
};
