import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { CarNotFound } from 'entities/Car/ui/CarNotFound/CarNotFound';

import { ErrorBoundaryFallbackProps } from 'shared/ui/ErrorBoundary/ErrorBoundary';

const storybookMeta = createStorybookMeta<ErrorBoundaryFallbackProps>({
    title: 'entities/Car/CarNotFound',
    component: CarNotFound,

    args: {
        storybookWidth: '100vw',
    },

    decorators: [withStorybookRouter()],
});

export default storybookMeta;

const Template = createStorybookTemplate<ErrorBoundaryFallbackProps>(CarNotFound);

export const normal = Template.bind({});
normal.args = {};
