import * as React from 'react';

import { Header } from 'widgets/Header';

import { ContentContainer } from 'shared/ui/ContentContainer/ContentContainer';
import { ErrorBoundaryFallbackProps } from 'shared/ui/ErrorBoundary/ErrorBoundary';
import { SectionLayout } from 'shared/ui/SectionLayout/SectionLayout';

import { i18n } from 'entities/Car/ui/CarNotFound/CarNotFound.i18n';

import styles from 'entities/Car/ui/CarNotFound/CarNotFound.css';

export const CarNotFound: React.FC<ErrorBoundaryFallbackProps> = function CarNotFound({ error }) {
    return (
        <SectionLayout
            header={
                <Header
                    title={i18n('Car')}
                    withoutBorder
                />
            }
            bodyScroll
        >
            <ContentContainer
                className={styles.content}
                bodyScroll
            >
                <h3 className={styles.title}>{i18n('Car not found')}</h3>
            </ContentContainer>
        </SectionLayout>
    );
};
