import * as React from 'react';

import { CarsFilter } from 'entities/Car/consts/CarsFilter';
import { CarSignalqStatusType } from 'entities/Car/consts/CarSignalqStatusType';
import { getCarSignalqStatus } from 'entities/Car/helpers/getCarSignalqStatus/getCarSignalqStatus';

import { CheckboxItemOptions } from 'shared/ui/Checkbox/Checkbox';
import { CheckboxGroup, CheckboxGroupProps } from 'shared/ui/CheckboxGroup/CheckboxGroup';
import { FilterGroup } from 'shared/ui/FilterGroup/FilterGroup';

import { i18n } from 'entities/Car/ui/CarsCameraStatusFilter/CarsCameraStatusFilter.i18n';

export interface CarsCameraStatusFilterProps extends Pick<CheckboxGroupProps, 'disabled'> {
    className?: string;
    values: Nullable<string>;

    onChangeFilter(type: string, value: string): void;
}

const FILTERS: CarSignalqStatusType[] = [
    CarSignalqStatusType.TURNED_ON,
    CarSignalqStatusType.TURNED_OFF,
    CarSignalqStatusType.OFFLINE,
    CarSignalqStatusType.FACED_AWAY,
    CarSignalqStatusType.CAMERA_CLOSED,
];

const ITEMS: CheckboxItemOptions[] = FILTERS.map((status) => ({ label: getCarSignalqStatus(status), id: status }));

export const CarsCameraStatusFilter: React.FC<CarsCameraStatusFilterProps> = function CarsCameraStatusFilter({
    className,
    values,
    onChangeFilter,
    ...otherProps
}) {
    const onChangeHandler = React.useCallback(
        (values: string[]) => {
            onChangeFilter(CarsFilter.SIGNALQ_STATUS, values.join(','));
        },
        [onChangeFilter],
    );

    return (
        <FilterGroup
            className={className}
            title={i18n('Camera Status')}
        >
            <CheckboxGroup
                {...otherProps}
                items={ITEMS}
                values={values?.split(',')}
                onChange={onChangeHandler}
            />
        </FilterGroup>
    );
};
