import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarsCarLoveClassFilter,
    CarsCarLoveClassFilterProps,
} from 'entities/Car/ui/CarsCarLoveClassFilter/CarsCarLoveClassFilter';

const storybookMeta = createStorybookMeta<CarsCarLoveClassFilterProps>({
    title: 'entities/Car/CarsCarLoveClassFilter',
    component: CarsCarLoveClassFilter,

    parameters: {
        flags: {
            carlove_custom_filters: {
                class: [
                    {
                        'en-US': 'All classes',
                        'ru-RU': 'Все классы',
                        tag: 'all',
                    },
                    {
                        'en-US': 'Economy',
                        'ru-RU': 'Эконом',
                        tag: 'economy_class',
                    },
                    {
                        'en-US': 'Standart',
                        'ru-RU': 'Стандарт',
                        tag: 'standart_class',
                    },
                    {
                        'en-US': 'Comfort',
                        'ru-RU': 'Комфорт',
                        tag: 'comfort_class',
                    },
                    {
                        'en-US': 'Business',
                        'ru-RU': 'Бизнес',
                        tag: 'business_class',
                    },
                ],
            },
        },
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsCarLoveClassFilterProps>(CarsCarLoveClassFilter);

export const normal = Template.bind({});
