import * as React from 'react';

import { getCustomCarLoveFilter } from 'utils/getCustomCarLoveFilter';

import { CarsFilter } from 'entities/Car/consts/CarsFilter';
import { getCarsFilterOptions } from 'entities/Car/helpers/getCarsFilterOptions/getCarsFilterOptions';

import { FilterGroup } from 'shared/ui/FilterGroup/FilterGroup';
import { RadioButton, RadioButtonProps } from 'shared/ui/RadioButton/RadioButton';

import { i18n } from 'entities/Car/ui/CarsCarLoveClassFilter/CarsCarLoveClassFilter.i18n';

export interface CarsCarLoveClassFilterProps extends Pick<RadioButtonProps, 'disabled'> {
    className?: string;
    value: Nullable<string>;

    onChangeFilter(type: string, value: string): void;
}

const DEFAULT_VALUE = 'all';

// @todo: move to feature CarsCarLoveFilters
export const CarsCarLoveClassFilter: React.FC<CarsCarLoveClassFilterProps> = function CarsCarLoveClassFilter({
    className,
    value,
    onChangeFilter,
    ...otherProps
}) {
    const carLoveFilters = getCustomCarLoveFilter();
    const filters = getCarsFilterOptions(carLoveFilters.class);

    const onChangeHandler = React.useCallback(
        (value: string) => {
            onChangeFilter(CarsFilter.CLASS, value);
        },
        [onChangeFilter],
    );

    if (!filters.length) {
        return null;
    }

    return (
        <FilterGroup
            className={className}
            title={i18n('Class')}
        >
            <RadioButton
                {...otherProps}
                items={filters}
                value={value || DEFAULT_VALUE}
                onChange={onChangeHandler}
            />
        </FilterGroup>
    );
};
