import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'New and old': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'New and old',
        ru: 'Новые и старые',
        cs: 'Nové a staré',
    },
    'New or old': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'New or old',
        ru: 'Новые или старые',
        cs: 'Nové nebo staré',
    },
    'Only new': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Only new',
        ru: 'Только новые',
        cs: 'Pouze nové',
    },
    'Only old': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Only old',
        ru: 'Только старые',
        cs: 'Pouze staré',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
