import * as React from 'react';

import { CarsFilter } from 'entities/Car/consts/CarsFilter';

import { FilterGroup } from 'shared/ui/FilterGroup/FilterGroup';
import { RadioButton, RadioButtonProps } from 'shared/ui/RadioButton/RadioButton';

import { i18n } from 'entities/Car/ui/CarsFreshFilter/CarsFreshFilter.i18n';

export interface CarsFreshFilterProps extends Pick<RadioButtonProps, 'disabled'> {
    className?: string;
    value: Nullable<string>;

    onChangeFilter(type: string, value: string): void;
}

const DEFAULT_VALUE = 'all';

const ITEMS = [
    {
        label: i18n('New and old'),
        id: DEFAULT_VALUE,
    },
    {
        label: i18n('Only new'),
        id: 'fresh_issue_date_tag',
    },
    {
        label: i18n('Only old'),
        id: '-fresh_issue_date_tag',
    },
];

export const CarsFreshFilter: React.FC<CarsFreshFilterProps> = function CarsFreshFilter({
    className,
    value,
    onChangeFilter,
    ...otherProps
}) {
    const onChangeHandler = React.useCallback(
        (value: string) => {
            onChangeFilter(CarsFilter.FRESH_ISSUE_DATE, value);
        },
        [onChangeFilter],
    );

    return (
        <FilterGroup
            className={className}
            title={i18n('New or old')}
        >
            <RadioButton
                {...otherProps}
                items={ITEMS}
                value={value || DEFAULT_VALUE}
                onChange={onChangeHandler}
            />
        </FilterGroup>
    );
};
