import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Hardware: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Hardware',
        ru: 'Оборудование',
        cs: 'Hardware',
    },
    'With camera': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'With camera',
        ru: 'С камерой',
        cs: 'S kamerou',
    },
    'With telematics': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'With telematics',
        ru: 'С телематикой',
        cs: 'S telematikou',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
