import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Do not perform SH': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Do not perform SH',
        ru: 'Не выполняют SH',
        cs: 'Neprovádějte SH',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
