import * as React from 'react';

import { CarsFilter } from 'entities/Car/consts/CarsFilter';

import { Checkbox, CheckboxProps } from 'shared/ui/Checkbox/Checkbox';

import { i18n } from 'entities/Car/ui/CarsNoShFilter/CarsNoShFilter.i18n';

export interface CarsNoShFilterProps extends Pick<CheckboxProps, 'checked' | 'disabled'> {
    className?: string;

    onChangeFilter(type: string, value: boolean): void;
}

export const CarsNoShFilter: React.FC<CarsNoShFilterProps> = function CarsNoShFilter({
    className,
    onChangeFilter,
    ...otherProps
}) {
    const onChangeHandler = React.useCallback(
        (checked: boolean) => {
            onChangeFilter(CarsFilter.NO_SH, checked);
        },
        [onChangeFilter],
    );

    return (
        <Checkbox
            {...otherProps}
            id={CarsFilter.NO_SH}
            label={i18n('Do not perform SH')}
            onChange={onChangeHandler}
        />
    );
};
