import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{count} car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: {
            one: '{count} car',
            other: '{count} cars',
            zero: 'No cars',
        },
        ru: {
            one: '{count} машина',
            few: '{count} машины',
            many: '{count} машин',
            zero: 'Нет машин',
        },
        cs: {
            one: '{count} auto',
            few: '{count} auta',
            other: '{count} aut',
            zero: 'Žádná auta',
        },
    },
    'No information': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'No information',
        ru: 'Нет информации',
        cs: 'Žádné informace',
    },
    'Show filters': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Show filters',
        ru: 'Показать фильтры',
        cs: 'Zobrazit filtry',
    },
    'Show more': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Show more',
        ru: 'Показать ещё',
        cs: 'Zobrazit více',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
