import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Car in service': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car in service',
        ru: 'Машина в сервисе',
        cs: 'Vůz v servisu',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
