import * as React from 'react';

import { CarsFilter } from 'entities/Car/consts/CarsFilter';

import { Checkbox, CheckboxProps } from 'shared/ui/Checkbox/Checkbox';
import { FilterGroup } from 'shared/ui/FilterGroup/FilterGroup';

import { i18n } from 'entities/Car/ui/CarsServiceFilter/CarsServiceFilter.i18n';

export interface CarsServiceFilterProps extends Pick<CheckboxProps, 'checked' | 'disabled'> {
    className?: string;

    onChangeFilter(type: string, value: boolean): void;
}

export const CarsServiceFilter: React.FC<CarsServiceFilterProps> = function CarsServiceFilter({
    className,
    onChangeFilter,
    ...otherProps
}) {
    const onChangeHandler = React.useCallback(
        (checked: boolean) => {
            onChangeFilter(CarsFilter.SERVICE, checked);
        },
        [onChangeFilter],
    );

    return (
        <FilterGroup
            className={className}
            title={i18n('Car in service')}
        >
            <Checkbox
                {...otherProps}
                id={CarsFilter.SERVICE}
                label={i18n('Car in service')}
                onChange={onChangeHandler}
            />
        </FilterGroup>
    );
};
