import * as React from 'react';

import { CarsFilter } from 'entities/Car/consts/CarsFilter';
import { CarStatusType } from 'entities/Car/consts/CarStatusType';
import { getCarStatus } from 'entities/Car/helpers/getCarStatus/getCarStatus';

import { CheckboxItemOptions } from 'shared/ui/Checkbox/Checkbox';
import { CheckboxGroup, CheckboxGroupProps } from 'shared/ui/CheckboxGroup/CheckboxGroup';
import { FilterGroup } from 'shared/ui/FilterGroup/FilterGroup';

import { i18n } from 'entities/Car/ui/CarsStatusFilter/CarsStatusFilter.i18n';

export interface CarsStatusFilterProps extends Pick<CheckboxGroupProps, 'disabled'> {
    className?: string;
    values: Nullable<string>;

    onChangeFilter(type: string, value: string): void;
}

const FILTERS: CarStatusType[] = [
    CarStatusType.NO_SIGNAL,
    CarStatusType.RIDING,
    CarStatusType.ENGINE_ON,
    CarStatusType.ENGINE_OFF,
    CarStatusType.INSTALLATION,
    CarStatusType.UNINSTALL_TELEMATICS,
    CarStatusType.BLOCKED,
];

const ITEMS: CheckboxItemOptions[] = FILTERS.map((status) => ({ label: getCarStatus(status), id: status }));

export const CarsStatusFilter: React.FC<CarsStatusFilterProps> = function CarsStatusFilter({
    className,
    values,
    onChangeFilter,
    ...otherProps
}) {
    const onChangeHandler = React.useCallback(
        (values: string[]) => {
            onChangeFilter(CarsFilter.STATUS, values.join(','));
        },
        [onChangeFilter],
    );

    return (
        <FilterGroup
            className={className}
            title={i18n('Status')}
        >
            <CheckboxGroup
                {...otherProps}
                items={ITEMS}
                values={values?.split(',')}
                onChange={onChangeHandler}
            />
        </FilterGroup>
    );
};
