import { ONE_SECOND, SECONDS_IN_MINUTE } from 'constants/constants';

import { GeoCodeSchema } from 'entities/Geo/types/GeoCodeSchema';

const MAX_GEOCODE_TIMEOUT = SECONDS_IN_MINUTE * ONE_SECOND;

const DEFAULT_OPTIONS: GeoCodeSchema = {
    kind: 'house',
};

export const getGeocode = (coords: (number | null)[], options?: GeoCodeSchema) => {
    return new Promise((resolve, reject) => {
        if (coords?.[0] === undefined || coords?.[0] === null || coords?.[1] === undefined || coords?.[1] === null) {
            reject(null);
        }

        Promise.race([
            ymaps?.geocode?.(coords, Object.assign(DEFAULT_OPTIONS, options ?? {})),
            new Promise((resolve, reject) => {
                setTimeout(() => {
                    reject(null);
                }, MAX_GEOCODE_TIMEOUT);
            }),
        ])
            .then((geocode) => {
                if (!geocode) {
                    throw new Error('Geocode result is undefined');
                }
                resolve(geocode);
            })
            .catch((geocodeError) => {
                reject(geocodeError);
            });
    });
};
