import { asyncRetry } from 'utils/asyncRetry';

import { getGeocode } from 'entities/Geo/helpers/geoCode/getGeocode';
import { GeoCodeSchema } from 'entities/Geo/types/GeoCodeSchema';

export const getAddress = async (coords: [number | null, number | null], options?: GeoCodeSchema) => {
    if (coords[0] === null || coords[1] === null) {
        return null;
    }

    let geoCodeResult = await asyncRetry(getGeocode.bind(null, coords, options));
    let firstGeoObject = geoCodeResult?.geoObjects.get(0) ?? {};

    let [city, thoroughfare, premiseNumber] = [
        firstGeoObject?.getLocalities?.(),
        firstGeoObject?.getThoroughfare?.(),
        firstGeoObject?.getPremiseNumber?.(),
    ];

    let addressObjects = [city, thoroughfare, premiseNumber]
        .reduce((addressArray, addressItem) => {
            if (Array.isArray(addressItem)) {
                addressArray.push(...addressItem);
            } else {
                addressArray.push(addressItem);
            }

            return addressArray;
        }, [])
        .filter((item) => item);

    let address = addressObjects?.length ? addressObjects.join(', ') : firstGeoObject?.getAddressLine?.();

    return address ?? coords?.join(', ');
};
