import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { GeoInput, GeoInputProps } from 'entities/Geo/ui/GeoInput/GeoInput';

import { InputSize } from 'shared/consts/InputSize';

const storybookMeta = createStorybookMeta<GeoInputProps>({
    title: 'entities/Geo/GeoInput',
    component: GeoInput,

    args: {
        storybookWidth: '320px',

        inputSize: InputSize.M,
        maxHeight: 270,
        placeholder: 'Pick-up point',
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<GeoInputProps>(GeoInput);

export const normal = Template.bind({});
normal.args = {
    geoSuggestOptions: {
        countries: 'cz',
        lang: 'en_US',
    },
    defaultItems: [
        // Politických vězňů 912/10
        {
            name: 'Politických Vězňů, 912/10',
            type: 'geo',
            desc: 'Praha, Česko',
            lat: 50.0824852,
            lon: 14.42966175,
            kind: 'house',
            geoid: 10511,
        },
        // Prague Airport
        {
            name: 'Prague Václav Havel airport',
            type: 'geo',
            desc: 'Praha, Česko',
            lat: 50.10686111,
            lon: 14.26646137,
            kind: 'airport',
            geoid: 10511,
        },
    ],
};

normal.hermioneFn = async (browser, selector) => {
    const menuEl = '[role="menu"]';

    await browser.$(selector).click();
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('suggest0', [selector, menuEl]);

    await browser.$('[type="text"]').setValue('na');
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('suggest1', [selector, menuEl]);

    await browser.$('[type="text"]').setValue('name');
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('suggest2', [selector, menuEl]);

    await browser.$('li[role="option"]:nth-child(1)').click();
    await browser.assertView('selected', selector);

    await browser.$('span[role="button"]').click();
    await browser.assertView('clear', selector);
};
