import { DAYS_IN_MONTH, DAYS_IN_WEEK, DAYS_IN_YEAR, ONE_DAY } from 'constants/constants';

import { PortfolioComparePeriod } from 'entities/Portfolio/consts/PortfolioComparePeriod';

export function getPortfolioComparePeriod(period: Nullable<PortfolioComparePeriod>): {
    dates: { until: number; since: number };
    old_dates: { until: number; since: number };
} {
    const DEFAULT_COMPARE_PERIOD = 60;

    let periodInDays = 0;

    switch (period) {
        case PortfolioComparePeriod.WEEK:
            periodInDays = DAYS_IN_WEEK;
            break;

        case PortfolioComparePeriod.MONTH:
            periodInDays = DAYS_IN_MONTH;
            break;

        case PortfolioComparePeriod.YEAR:
            periodInDays = DAYS_IN_YEAR;
            break;

        case PortfolioComparePeriod.ALL:
            periodInDays = DEFAULT_COMPARE_PERIOD;
            break;
    }

    const currentDay = Math.trunc(Date.now() / ONE_DAY);

    const sinceDay = currentDay - periodInDays - 1; //period without including
    const untilOldDay = sinceDay - 1;
    const untilSinceDay = untilOldDay - periodInDays - 1;

    return {
        dates: {
            until: currentDay,
            since: sinceDay,
        },
        old_dates: {
            until: untilOldDay,
            since: untilSinceDay,
        },
    };
}
