import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Dashboard: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dashboard',
        ru: 'Дашборд',
        cs: 'Informační panel',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
