import * as React from 'react';
import cn from 'classnames';

import { IPortfolioData } from 'components/Portfolio/PortfolioTable/types';
import DashboardScoringLabel from 'components/ui/DashboardScoringLabel';

import { i18n } from 'entities/Portfolio/ui/PortfolioHeaderTitle/PortfolioHeaderTitle.i18n';

import styles from 'entities/Portfolio/ui/PortfolioHeaderTitle/PortfolioHeaderTitle.css';

export interface PortfolioHeaderTitleProps {
    className?: string;
    // @todo: portfolioData: Pick<IPortfolioData, 'score'>;
    portfolioData: IPortfolioData | null;
}

export const PortfolioHeaderTitle: React.FC<PortfolioHeaderTitleProps> = React.memo(function PortfolioHeaderTitle({
    className,
    portfolioData,
}) {
    return (
        <div className={cn(styles.portfolioHeaderTitle, className)}>
            <h1 className={styles.title}>{i18n('Dashboard')}</h1>

            {portfolioData?.hasOwnProperty('score') && <DashboardScoringLabel score={portfolioData?.score ?? null} />}
        </div>
    );
});
