import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'All time': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'All time',
        ru: 'За всё время',
        cs: 'Za celou dobu',
    },
    'Compare period': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Compare period',
        ru: 'Период сравнения',
        cs: 'Srovnávací období',
    },
    'Month to month': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Month to month',
        ru: 'Месяц к месяцу',
        cs: 'Měsíčně',
    },
    'Week to week': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Week to week',
        ru: 'Неделя к неделе',
        cs: 'Týdně',
    },
    'Year to year': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Year to year',
        ru: 'Год к году',
        cs: 'Ročně',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
