import * as React from 'react';

import { PortfolioComparePeriod } from 'entities/Portfolio/consts/PortfolioComparePeriod';
import { PortfolioFilter } from 'entities/Portfolio/consts/PortfolioFilter';

import { FilterGroup } from 'shared/ui/FilterGroup/FilterGroup';
import { RadioButton, RadioButtonItemOptions, RadioButtonProps } from 'shared/ui/RadioButton/RadioButton';

import { i18n } from 'entities/Portfolio/ui/PortfolioPeriodFilter/PortfolioPeriodFilter.i18n';

export interface PortfolioPeriodFilterProps extends Pick<RadioButtonProps, 'disabled'> {
    className?: string;
    value: Nullable<string>;

    onChangeFilter(type: string, value: string): void;
}

export const PortfolioPeriodFilter: React.FC<PortfolioPeriodFilterProps> = function PortfolioPeriodFilter({
    className,
    value,
    onChangeFilter,
    ...otherProps
}) {
    const items: RadioButtonItemOptions[] = React.useMemo(
        () => [
            {
                label: i18n('All time'),
                id: PortfolioComparePeriod.ALL,
            },

            {
                label: i18n('Year to year'),
                id: PortfolioComparePeriod.YEAR,
            },

            {
                label: i18n('Month to month'),
                id: PortfolioComparePeriod.MONTH,
            },

            {
                id: PortfolioComparePeriod.WEEK,
                label: i18n('Week to week'),
            },
        ],

        [],
    );

    const onChangeHandler = React.useCallback(
        (value: string) => {
            onChangeFilter(PortfolioFilter.COMPARE_PERIOD, value);
        },
        [onChangeFilter],
    );

    return (
        <FilterGroup
            className={className}
            title={i18n('Compare period')}
        >
            <RadioButton
                {...otherProps}
                items={items}
                value={value || PortfolioComparePeriod.ALL}
                onChange={onChangeHandler}
            />
        </FilterGroup>
    );
};
